/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.launcher.Launcher;

public class ExceptionalThreadPoolExecutor
extends ThreadPoolExecutor {
    public ExceptionalThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected RunnableFuture newTaskFor(Runnable runnable, Object value) {
        return new ExceptionalFutureTask(runnable, value);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new ExceptionalFutureTask(callable);
    }

    public class ExceptionalFutureTask
    extends FutureTask {
        final ExceptionalThreadPoolExecutor this$0;

        public ExceptionalFutureTask(Callable callable) {
            super(callable);
            this.this$0 = ExceptionalThreadPoolExecutor.this;
        }

        public ExceptionalFutureTask(Runnable runnable, Object result) {
            super(runnable, result);
            this.this$0 = ExceptionalThreadPoolExecutor.this;
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (Throwable t) {
                Launcher.getInstance().println("Unhandled exception in executor " + this, t);
            }
        }
    }
}

