/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.minecraft.Launcher;
import net.minecraft.LoginForm;
import net.minecraft.Util;

public class LauncherFrame
extends Frame {
    public static final int VERSION = 13;
    private static final long serialVersionUID = 1L;
    public Map<String, String> customParameters = new HashMap<String, String>();
    public Launcher launcher;
    public LoginForm loginForm;

    public LauncherFrame() {
        super("Minecraft Launcher");
        this.setBackground(Color.BLACK);
        this.loginForm = new LoginForm(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.loginForm, "Center");
        jPanel.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
        try {
            this.setIconImage(ImageIO.read(LauncherFrame.class.getResource("favicon.png")));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        System.out.println("FORCING EXIT!");
                        System.exit(0);
                    }
                }.start();
                if (LauncherFrame.this.launcher != null) {
                    LauncherFrame.this.launcher.stop();
                    LauncherFrame.this.launcher.destroy();
                }
                System.exit(0);
            }
        });
    }

    public void playCached(String string, boolean bl) {
        try {
            if (string == null || string.length() <= 0) {
                string = "Player";
            }
            this.launcher = new Launcher();
            this.launcher.customParameters.putAll(this.customParameters);
            this.launcher.customParameters.put("userName", string);
            this.launcher.customParameters.put("demo", "" + bl);
            this.launcher.customParameters.put("sessionId", "1");
            this.launcher.init();
            this.removeAll();
            this.add((Component)this.launcher, "Center");
            this.validate();
            this.launcher.start();
            this.loginForm = null;
            this.setTitle("Minecraft");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showError(exception.toString());
        }
    }

    public void login(String string, String string2) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("user", string);
            hashMap.put("password", string2);
            hashMap.put("version", 13);
            String string3 = Util.executePost("https://login.minecraft.net/", hashMap);
            if (string3 == null) {
                this.showError("Can't connect to minecraft.net");
                this.loginForm.setNoNetwork(false);
                return;
            }
            if (!string3.contains(":")) {
                boolean bl = false;
                if (string3.trim().equals("Bad login")) {
                    this.showError("Login failed");
                } else if (string3.trim().equals("Old version")) {
                    this.loginForm.setOutdated();
                    this.showError("Outdated launcher");
                } else if (string3.trim().equals("User not premium")) {
                    this.showError(string3);
                    bl = true;
                } else {
                    this.showError(string3);
                }
                this.loginForm.setNoNetwork(bl);
                return;
            }
            String[] stringArray = string3.split(":");
            this.launcher = new Launcher();
            this.launcher.customParameters.putAll(this.customParameters);
            this.launcher.customParameters.put("userName", stringArray[2].trim());
            this.launcher.customParameters.put("latestVersion", stringArray[0].trim());
            this.launcher.customParameters.put("downloadTicket", stringArray[1].trim());
            this.launcher.customParameters.put("sessionId", stringArray[3].trim());
            this.launcher.init();
            this.removeAll();
            this.add((Component)this.launcher, "Center");
            this.validate();
            this.launcher.start();
            this.loginForm.loginOk();
            this.loginForm = null;
            this.setTitle("Minecraft");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showError(exception.toString());
            this.loginForm.setNoNetwork(false);
        }
    }

    private void showError(String string) {
        this.removeAll();
        this.add(this.loginForm);
        this.loginForm.setError(string);
        this.validate();
    }

    public boolean canPlayOffline(String string) {
        Launcher launcher = new Launcher();
        launcher.customParameters.putAll(this.customParameters);
        launcher.init(string, null, null, "1");
        return launcher.canPlayOffline();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("asdf");
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("java.net.preferIPv6Addresses", "false");
        LauncherFrame launcherFrame = new LauncherFrame();
        launcherFrame.setVisible(true);
        launcherFrame.customParameters.put("stand-alone", "true");
        String string = null;
        String string2 = null;
        for (String string3 : stringArray) {
            if (string3.startsWith("-u=") || string3.startsWith("--user=")) {
                string = LauncherFrame.getArgValue(string3);
                launcherFrame.customParameters.put("username", string);
                launcherFrame.loginForm.userName.setText(string);
                continue;
            }
            if (string3.startsWith("-p=") || string3.startsWith("--password=")) {
                string2 = LauncherFrame.getArgValue(string3);
                launcherFrame.customParameters.put("password", string2);
                launcherFrame.loginForm.password.setText(string2);
                continue;
            }
            if (!string3.startsWith("--noupdate")) continue;
            launcherFrame.customParameters.put("noupdate", "true");
        }
        if (stringArray.length >= 3) {
            Object object = stringArray[2];
            String string4 = "25565";
            if (((String)object).contains(":")) {
                String[] stringArray2 = ((String)object).split(":");
                object = stringArray2[0];
                string4 = stringArray2[1];
            }
            launcherFrame.customParameters.put("server", (String)object);
            launcherFrame.customParameters.put("port", string4);
        }
    }

    private static String getArgValue(String string) {
        int n = string.indexOf(61);
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }
}

