/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.GameUpdater;
import net.minecraft.LoginForm;

public class Launcher
extends Applet
implements Runnable,
AppletStub,
MouseListener {
    private static final long serialVersionUID = 1L;
    public Map<String, String> customParameters = new HashMap<String, String>();
    private GameUpdater gameUpdater;
    private boolean gameUpdaterStarted = false;
    private Applet applet;
    private Image bgImage;
    private boolean active = false;
    private int context = 0;
    private boolean hasMouseListener = false;
    private VolatileImage img;

    public boolean isActive() {
        if (this.context == 0) {
            this.context = -1;
            try {
                if (this.getAppletContext() != null) {
                    this.context = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.context == -1) {
            return this.active;
        }
        return super.isActive();
    }

    public void init(String string, String string2, String string3, String string4) {
        try {
            this.bgImage = ImageIO.read(LoginForm.class.getResource("dirt.png")).getScaledInstance(32, 32, 16);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.customParameters.put("username", string);
        this.customParameters.put("sessionid", string4);
        this.gameUpdater = new GameUpdater(string2, "minecraft.jar?user=" + string + "&ticket=" + string3, this.customParameters.containsKey("noupdate"));
    }

    public boolean canPlayOffline() {
        return this.gameUpdater.canPlayOffline();
    }

    public void init() {
        if (this.applet != null) {
            this.applet.init();
            return;
        }
        this.init(this.getParameter("userName"), this.getParameter("latestVersion"), this.getParameter("downloadTicket"), this.getParameter("sessionId"));
    }

    public void start() {
        if (this.applet != null) {
            this.applet.start();
            return;
        }
        if (this.gameUpdaterStarted) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                Launcher.this.gameUpdater.run();
                try {
                    if (!((Launcher)Launcher.this).gameUpdater.fatalError) {
                        Launcher.this.replace(Launcher.this.gameUpdater.createApplet());
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        thread = new Thread(){

            public void run() {
                while (Launcher.this.applet == null) {
                    Launcher.this.repaint();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        this.gameUpdaterStarted = true;
    }

    public void stop() {
        if (this.applet != null) {
            this.active = false;
            this.applet.stop();
        }
    }

    public void destroy() {
        if (this.applet != null) {
            this.applet.destroy();
        }
    }

    public void replace(Applet applet) {
        this.applet = applet;
        applet.setStub(this);
        applet.setSize(this.getWidth(), this.getHeight());
        this.setLayout(new BorderLayout());
        this.add((Component)applet, "Center");
        applet.init();
        this.active = true;
        applet.start();
        this.validate();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.applet != null) {
            return;
        }
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        if (this.img == null || this.img.getWidth() != n || this.img.getHeight() != n2) {
            this.img = this.createVolatileImage(n, n2);
        }
        Graphics graphics2 = this.img.getGraphics();
        for (int i = 0; i <= n / 32; ++i) {
            for (int j = 0; j <= n2 / 32; ++j) {
                graphics2.drawImage(this.bgImage, i * 32, j * 32, null);
            }
        }
        if (this.gameUpdater.pauseAskUpdate) {
            if (!this.hasMouseListener) {
                this.hasMouseListener = true;
                this.addMouseListener(this);
            }
            graphics2.setColor(Color.LIGHT_GRAY);
            String string = "New update available";
            graphics2.setFont(new Font(null, 1, 20));
            FontMetrics fontMetrics = graphics2.getFontMetrics();
            graphics2.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, n2 / 2 - fontMetrics.getHeight() * 2);
            graphics2.setFont(new Font(null, 0, 12));
            fontMetrics = graphics2.getFontMetrics();
            graphics2.fill3DRect(n / 2 - 56 - 8, n2 / 2, 56, 20, true);
            graphics2.fill3DRect(n / 2 + 8, n2 / 2, 56, 20, true);
            string = "Would you like to update?";
            graphics2.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, n2 / 2 - 8);
            graphics2.setColor(Color.BLACK);
            string = "Yes";
            graphics2.drawString(string, n / 2 - 56 - 8 - fontMetrics.stringWidth(string) / 2 + 28, n2 / 2 + 14);
            string = "Not now";
            graphics2.drawString(string, n / 2 + 8 - fontMetrics.stringWidth(string) / 2 + 28, n2 / 2 + 14);
        } else {
            graphics2.setColor(Color.LIGHT_GRAY);
            String string = "Updating Minecraft";
            if (this.gameUpdater.fatalError) {
                string = "Failed to launch";
            }
            graphics2.setFont(new Font(null, 1, 20));
            FontMetrics fontMetrics = graphics2.getFontMetrics();
            graphics2.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, n2 / 2 - fontMetrics.getHeight() * 2);
            graphics2.setFont(new Font(null, 0, 12));
            fontMetrics = graphics2.getFontMetrics();
            string = this.gameUpdater.getDescriptionForState();
            if (this.gameUpdater.fatalError) {
                string = this.gameUpdater.fatalErrorDescription;
            }
            graphics2.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, n2 / 2 + fontMetrics.getHeight() * 1);
            string = this.gameUpdater.subtaskMessage;
            graphics2.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, n2 / 2 + fontMetrics.getHeight() * 2);
            if (!this.gameUpdater.fatalError) {
                graphics2.setColor(Color.black);
                graphics2.fillRect(64, n2 - 64, n - 128 + 1, 5);
                graphics2.setColor(new Color(32768));
                graphics2.fillRect(64, n2 - 64, this.gameUpdater.percentage * (n - 128) / 100, 4);
                graphics2.setColor(new Color(0x20A020));
                graphics2.fillRect(65, n2 - 64 + 1, this.gameUpdater.percentage * (n - 128) / 100 - 2, 1);
            }
        }
        graphics2.dispose();
        graphics.drawImage(this.img, 0, 0, n * 2, n2 * 2, null);
    }

    public void run() {
    }

    public String getParameter(String string) {
        String string2 = this.customParameters.get(string);
        if (string2 != null) {
            return string2;
        }
        try {
            return super.getParameter(string);
        }
        catch (Exception exception) {
            this.customParameters.put(string, null);
            return null;
        }
    }

    public void appletResize(int n, int n2) {
    }

    public URL getDocumentBase() {
        try {
            return new URL("http://www.minecraft.net/game/");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        int n4 = mouseEvent.getX() / 2;
        if (this.contains(n4, n3 = mouseEvent.getY() / 2, (n2 = this.getWidth() / 2) / 2 - 56 - 8, (n = this.getHeight() / 2) / 2, 56, 20)) {
            this.removeMouseListener(this);
            this.gameUpdater.shouldUpdate = true;
            this.gameUpdater.pauseAskUpdate = false;
            this.hasMouseListener = false;
        }
        if (this.contains(n4, n3, n2 / 2 + 8, n / 2, 56, 20)) {
            this.removeMouseListener(this);
            this.gameUpdater.shouldUpdate = false;
            this.gameUpdater.pauseAskUpdate = false;
            this.hasMouseListener = false;
        }
    }

    private boolean contains(int n, int n2, int n3, int n4, int n5, int n6) {
        return n >= n3 && n2 >= n4 && n < n3 + n5 && n2 < n4 + n6;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

